<%--
$Header: ClientUtils.inc, 20, 5/1/01 9:35:51 AM, Schwartz, Joe$
$Log: 
 20   Alkindi Development1.19        5/1/01 9:35:51 AM    Schwartz, Joe  
      Removed method to retrieve AdminManager bean.
 19   Alkindi Development1.18        3/8/01 12:32:18 PM   Schwartz, Joe   Fixed
      up to work again with sessionless RecMgr.
 18   Alkindi Development1.17        3/5/01 2:29:03 PM    Schwartz, Joe  
      Changes to accomodate persistent RecMgr connection.
 17   Alkindi Development1.16        2/23/01 7:23:05 PM   Schwartz, Joe  
      Cleaned up code a bit.
 16   Alkindi Development1.15        2/23/01 5:39:17 PM   Schwartz, Joe   Basic
      changes for new RecMgr interface, new Product id type (int) and
      Rating/Recommendation evaluation type (float).
 15   Alkindi Development1.14        1/18/01 4:04:58 PM   Schwartz, Joe  
      Changed String compareTo() to equals() where possible; renamed _SESSID
      constants to _SESSVAR.
 14   Alkindi Development1.13        1/5/01 6:06:28 PM    Schwartz, Joe  
      Removed some whitespace.
 13   Alkindi Development1.12        1/5/01 1:18:26 PM    Schwartz, Joe   Added
      souce control keywords.
 12   Alkindi Development1.11        12/11/00 3:32:25 PM  Schwartz, Joe  
      Modifed to used default JNDI context. 
 11   Alkindi Development1.10        12/4/00 2:21:39 PM   Schwartz, Joe  
      Removed debug printout of JNDI property file load.
 10   Alkindi Development1.9         12/4/00 12:47:23 PM  Schwartz, Joe   
 9    Alkindi Development1.8         12/2/00 1:33:15 PM   Schwartz, Joe  
      Modified to use jndi properties from file jndi.properties.
 8    Alkindi Development1.7         12/1/00 7:24:51 PM   Schwartz, Joe  
      Adjusted to use Orion Server for JNDI lookups.
 7    Alkindi Development1.6         12/1/00 2:44:27 PM   Schwartz, Joe   
 6    Alkindi Development1.5         12/1/00 1:17:25 PM   Stanton, Sacha  
 5    Alkindi Development1.4         11/21/00 11:17:29 PM Schwartz, Joe   
 4    Alkindi Development1.3         11/20/00 10:51:08 PM Schwartz, Joe   
 3    Alkindi Development1.2         11/19/00 6:04:21 PM  Schwartz, Joe   
 2    Alkindi Development1.1         11/11/00 5:00:51 PM  Schwartz, Joe   
 1    Alkindi Development1.0         11/11/00 11:24:35 AM Schwartz, Joe   
$
$NoKeywords$

	Include file for accessing the Alkindi Business Services
	remote objects. This acts as the interface to the EJB client
	code.
--%><%!
final String JNDI_PROPNAME = "jndiProps";
final String RECMGR_SESSVAR = "RecMgrBean";

// Methods useful to all JSPs appear in this file.
//
//
public String curDir() {
	return this.getServletConfig().getServletContext().getRealPath("/");
}

boolean useStubs = false;
boolean checkedUseStubs = false;
public boolean useStubBeans() {
	if (!checkedUseStubs) {
		String sFlag = getServletConfig().getServletContext().getInitParameter("UseStubBeans");
		if (sFlag.equals("1"))
			useStubs = true;
	}
	return useStubs;
}


//////////////////////////////////////////////////////////////
//
//	getInitCtx()
//
//		Sets up JNDI environment.
//
public InitialContext getInitCtx() throws NamingException, IOException
{
	//	Set a Security Manager if not already done.
	//
/*	if (System.getSecurityManager() == null) {
		System.setSecurityManager(new java.rmi.RMISecurityManager());
	}*/
	return new InitialContext();

}

//////////////////////////////////////////////////////////////
//
//	getHomeIface()
//
//		Obtains a naming context and looks up the 
//		requested home interface.
//		Currently uses Jonas over RMI.
//
public Object getHomeIface(String iface) throws AlkExcept
{
	try {
		Context ctx = getInitCtx();
		if (ctx == null)
			System.out.println("NULL initial context");
		Object obj = ctx.lookup(iface);
		ctx.close();
		return obj;
	}
	catch(Exception e) {
		throw new AlkExcept(e.toString(), 7001);
	}
}

//////////////////////////////////////////////////////////////
//
//	getAcctMgr()
//
//		Returns an instance of IAccountManagerBean
//		running on the EJB server.
//
//
public IAccountManagerBean getAcctMgr() throws AlkExcept
{
	try {
		if (useStubBeans()) {
			return new AccountManagerStub();
		}
		else {
			Object obj = getHomeIface("java:comp/env/ejb/AcctMgrBean");
			IAccountManagerHome home = (IAccountManagerHome) PortableRemoteObject.narrow(obj, IAccountManagerHome.class);
			IAccountManagerBean acctMgr =(IAccountManagerBean)home.create();
			home = null;
			obj = null;
			return acctMgr;
		}
	}
	catch (AlkExcept ae) {
		throw ae;
	}
	catch (Exception e) {
		throw new AlkExcept("Exception: " + e.toString(), 7002);
	}

}

//////////////////////////////////////////////////////////////
//
//	getClusterMgr()
//
//		Returns an instance of IClusterManagerBean
//		running on the EJB server.
//
//
public IClusterManagerBean getClusterMgr() throws AlkExcept, RemoteException, javax.ejb.CreateException
{
	try {
		if (useStubBeans()) {
			return new ClusterManagerStub();
		}
		else {
			Object obj = getHomeIface("java:comp/env/ejb/ClusterMgrBean");
			IClusterManagerBean clusterMgr = null;
			if (null != obj) {
				IClusterManagerHome home = (IClusterManagerHome) PortableRemoteObject.narrow(obj, IClusterManagerHome.class);
				clusterMgr = home.create();
				home = null;
			}
			obj = null;
			return clusterMgr;
		}
	}
	catch (AlkExcept ae) {
		throw ae;
	}
	catch (Exception e) {
		throw new AlkExcept("Exception: " + e.toString(), 7004);
	}
	
}

//////////////////////////////////////////////////////////////
//
//	getRatingMgr()
//
//		Returns an instance of IRatingManagerBean
//		running on the EJB server.
//
//
public IRatingManagerBean getRatingMgr() throws AlkExcept, RemoteException, javax.ejb.CreateException
{
	try {
		if (useStubBeans()) {
			return new RatingManagerStub();
		}
		else {
			Object obj = getHomeIface("java:comp/env/ejb/RatingMgrBean");
			IRatingManagerBean ratMgr = null;
			if (null != obj) {
				IRatingManagerHome home = (IRatingManagerHome) PortableRemoteObject.narrow(obj, IRatingManagerHome.class);
				ratMgr = home.create();
				home = null;

			}
			obj = null;
			return ratMgr;
		}
	}
	catch (AlkExcept ae) {
		throw ae;
	}
	catch (Exception e) {
		throw new AlkExcept("Exception: " + e.toString(), 7005);
	}

	
}

/////////////////////////////////////////////////////////////////////
//
//	getRecMgr()
//
//		Returns an instance of IRecommendationManagerBean
//		running on the EJB server.
//
//
public IRecommendationManagerBean getRecMgr() throws AlkExcept, RemoteException, javax.ejb.CreateException
{
	
	try {
		if (useStubBeans()) {
			return new RecommendationManagerStub();
			
		}
		else {
			Object obj = getHomeIface("java:comp/env/ejb/RecMgrBean");
			IRecommendationManagerBean recMgr = null;
			if (null != obj) {
				IRecommendationManagerHome home = (IRecommendationManagerHome) PortableRemoteObject.narrow(obj, IRecommendationManagerHome.class);
				recMgr = home.create();
				home = null;
			}
			obj = null;
			return recMgr;
		}
	}
	catch (AlkExcept ae) {
		throw ae;
	}
	catch (Exception e) {
		throw new AlkExcept("Exception: " + e.toString(), 7006);
	}
	
}

//////////////////////////////////////////////////////////////
//
//	getSearchMgr()
//
//		Returns an instance of ISearchManagerBean
//		running on the EJB server.
//
//
public ISearchManagerBean getSearchMgr() throws AlkExcept, RemoteException, javax.ejb.CreateException
{
	try {
		if (useStubBeans()) {
			return new SearchManagerStub();
			
		}
		else {
			Object obj = getHomeIface("java:comp/env/ejb/SearchMgrBean");
			ISearchManagerBean searchMgr = null;
			if (null != obj) {
				ISearchManagerHome home = (ISearchManagerHome) PortableRemoteObject.narrow(obj, ISearchManagerHome.class);
				searchMgr = home.create();
				home = null;
			}
			obj = null;
			return searchMgr;
		}	
	}
	catch (AlkExcept ae) {
		throw ae;
	}
	catch (Exception e) {
		throw new AlkExcept("Exception: " + e.toString(), 7007);
	}

}


%>
